<?php

declare(strict_types=1);

namespace Erlage\Photogram;

use R;
use Exception;

final class Database
{
    /**
     * @return Database 
     */
    final public static function instance()
    {
        static $instance = false;

        if (false === $instance)
        {
            $instance = new Database();
        }

        return $instance;
    }

    public function init(): void
    {
        switch (DATABASE_TYPE)
        {
            case DATABASE_TYPE_MYSQL:
            case DATABASE_TYPE_MARIA_DB:
                R::setup(
                    \sprintf(
                        'mysql:host=%s;port=%s;dbname=%s',
                        DATABASE_HOST,
                        strlen(DATABASE_PORT) == 0 ? '3306' : DATABASE_PORT,
                        DATABASE_NAME
                    ),
                    DATABASE_USER,
                    DATABASE_PASS
                );

            break;

            case DATABASE_TYPE_POSTGRESQL:
                R::setup(
                    \sprintf(
                        'pgsql:host=%s;port=%s;dbname=%s',
                        DATABASE_HOST,
                        strlen(DATABASE_PORT) == 0 ? '5432' : DATABASE_PORT,
                        DATABASE_NAME
                    ),
                    DATABASE_USER,
                    DATABASE_PASS
                );

            break;

            case 'Cubrid':
                R::setup(
                    \sprintf(
                        'cubrid:host=%s;port=%s;dbname=%s',
                        DATABASE_HOST,
                        DATABASE_PORT,
                        DATABASE_NAME
                    ),
                    DATABASE_USER,
                    DATABASE_PASS
                );

            break;

            case 'SQLite':
                R::setup(
                    \sprintf('sqlite:/tmp/%s.db', DATABASE_NAME)
                );

            break;

            default: throw new Exception('Invalid database configuration');
        }

        if (FREEZE_SCHEMA)
        {
            R::freeze();
        }

        if (MODE_LOG_DATABASE_ADAPTER)
        {
            R::startLogging();
        }
    }
}
